(function(){
  // Start the widget script
  const widgetHTML = `
    <style>
      :root {
        --widget-max-width: 300px;
      }

      #social-proof-widget {
        position: fixed;
        bottom: 20px;
        right: 20px;
        z-index: 9999;
        font-family: system-ui, -apple-system, BlinkMacSystemFont, sans-serif;
        width: var(--widget-max-width);
        max-width: calc(100% - 32px);
        background: #0f1118;
        color: #fff;
        border-radius: 14px;
        padding: 16px;
        box-shadow: 0 25px 60px -10px rgba(0,0,0,0.7);
        overflow: hidden;
        transition: opacity .35s ease;
      }

      @media (max-width: 768px) {
        #social-proof-widget {
          right: 16px;
          left: auto;
          width: calc(100% - 32px);
        }
      }

      @media (max-width: 480px) {
        #social-proof-widget {
          right: 12px;
          left: 12px;
          width: auto;
          max-width: 92%;
          padding: 14px;
          font-size: 0.9rem;
        }

        #social-proof-widget div[style*="font-size:1.1rem"] {
          font-size: 1rem !important;
        }

        #social-proof-widget div[style*="font-size:.75rem"] {
          font-size: 0.7rem !important;
        }

        #social-proof-widget div[style*="height: 60px"] {
          height: auto !important;
        }
      }
    </style>

    <div id="social-proof-widget">
      <div style="display:flex; align-items:center; gap:8px;">
        <div style="background:#1e90ff; padding:6px 12px; border-radius:8px; font-size:.7rem; font-weight:700; color:#fff;">
          HOT
        </div>
        <div style="font-size:1.1rem; font-weight:700;">Live Buys</div>
      </div>

      <div id="status-msg" style="margin-top:8px; font-size:.75rem; min-height:22px;">
        <span style="color:#00ffff;">Tracking today's activity.</span>
      </div>

      <div id="recent-list" style="margin-top:12px; display:flex; flex-direction:column; gap:8px; max-height:128px; overflow-y:auto; scrollbar-width:thin;"></div>

      <div style="margin-top:14px; display:flex; justify-content:space-between; align-items:center;">
        <div style="font-size:.65rem; opacity:.85;">Total purchases today: <span id="total-count">0</span></div>
      </div>

      <div id="pulse" aria-hidden="true" style="position:absolute; inset:0; pointer-events:none;"></div>
    </div>
  `;

  // Inject the widget into the body
  document.body.insertAdjacentHTML('beforeend', widgetHTML);

  // Widget functionality
  const STARTING_TOTAL = 9;
  const MIN_INTERVAL_MS = 20000;
  const MAX_INTERVAL_MS = 60000;
  const MAX_RECENT = 50;
  const STORAGE_KEY = "sp_widget_state_v5_unique_queue";
  const PRODUCT_NAME = "Sales Profit Booster";

  const fullNameList = [
"Tina Stafford", "Kevin Hamilton", "Diana Dixon", "Samuel Cook", "Catherine Castillo", "Ariel Murphy", "Melanie Reilly", "Virginia Brown", "Pamela Byrd", "Alejandro Smith",
"Elizabeth Richardson", "Patricia Brown", "Andrea Gutierrez", "George King", "Angela Edwards", "Sara Nguyen", "Robin Chen", "Jerry Cook", "Sara Newman", "Mallory Mckenzie",
"Victor Roberson", "Stephen White", "Sarah Thomas", "James Lloyd", "Stefanie Monroe", "Alyssa Hernandez", "Lori Hernandez", "Kenneth Durham", "Mary Waters", "Susan Sanders",
"Mary Morgan", "Dakota King", "Jamie Davis", "Daniel Lee", "Brooke Hernandez", "David Sherman", "Catherine Odonnell", "Elizabeth Ashley", "Stacy Carson", "Brian Snyder",
"Jodi Martinez", "Kelly Lee", "Gerald Quinn", "Chad Atkins", "Rachel Jones", "Andrea Robertson", "Jason Braun", "Daniel Thompson", "Darrell Farrell", "Christopher Arnold",
"Jay Gilbert", "Kenneth Church", "Steven Carroll", "Jasmine Butler", "Matthew Hunter", "Rebecca Rivera", "James Campbell", "Gregory Alvarez", "Anthony Williams", "Katherine Guerrero",
"Blake Chaney", "Donna Coleman", "Heather Walters", "Cassandra Richardson", "Scott Hopkins", "Christian Page", "Jeffrey Walker", "John Gibson", "Jason Smith", "Melissa Taylor",
"Travis Short", "Joseph Hudson", "Maureen Martin", "Amanda Powell", "Jack Smith", "Ryan Jennings", "Spencer Figueroa", "Paul Pratt", "Nicole Olsen", "Scott Schaefer",
"Victor Alvarez", "Haley Benson", "Steven Arnold", "Jennifer Tate", "Janet Martin", "Alejandro Weaver", "Melissa Tapia", "Crystal Roberts", "James Hunt", "Joe Morales",
"Alexander Burgess", "Ashley Murray", "Megan Thomas", "Theresa Bauer", "Rhonda Davila", "Tiffany Case", "Jacob Sanders", "Christopher Williams", "Michael Dudley", "David Holmes",
"Shawn Summers", "Anthony Walker", "Tim Jackson", "Angela Jackson", "Roger Johnson", "Victoria Rice", "Virginia Cardenas", "Christina Aguilar", "Jason Jackson", "Paige Frank",
"Leah Charles", "Kimberly Davidson", "Laura Cook", "Mark Turner", "Amanda Cross", "Jennifer Foster", "Sharon Mckee", "Christine Wilkerson", "Joshua Murphy", "Kevin Buckley",
"Shawn Johnson", "Kelly Schmidt", "April Moon", "Amanda Brown", "Jessica Evans", "Amanda Sandoval", "George Wyatt", "Jose Vaughan", "Valerie Cox", "Rachel Campbell",
"Johnny Gonzalez", "Jessica Perry", "Jeffery Kennedy", "George Harmon", "Maria Thompson", "Jennifer Raymond", "Teresa Herrera", "Vanessa Smith", "Steven Robbins", "Heidi Campbell",
"Nina Ruiz", "Patrick Craig", "Jessica Allen", "Nathan Bauer", "Melissa Johnson", "Danielle Keller", "Gregory Bautista", "Amber Austin", "Donald Fitzpatrick", "Dustin Fleming",
"Linda Oconnor", "Daniel Humphrey", "Jacqueline Brown", "Rita Wolf", "Amber Fletcher", "Shawn Bell", "Dennis Ford", "Lori Velazquez", "Karen Perez", "Amy Clark",
"Joseph Green", "Chad Chandler", "Matthew Oneill", "David Foster", "Tara Robertson", "Anthony Owen", "Jeff Boyd", "Barbara Steele", "Deanna Moran", "Robin Lopez",
"Frank Reed", "Robert Cordova", "Elizabeth Choi", "Nicole Glenn", "Ashley Williams", "Melissa Davis", "Brooke Hess", "Bryan Dorsey", "Joshua Hamilton", "Chris Washington",
"Jennifer Shields", "Melvin White", "Kiara Maddox", "Jessica Burgess", "David Hill", "Daniel Johnson", "Tammy Hogan", "Frances Stewart", "Savannah Nguyen", "Jerry Mata",
"Tiffany Chen", "Brandy Murphy", "Brett Bailey", "Russell Moreno", "James Kelly", "Matthew Barker", "Craig Wong", "Kathryn Freeman", "Heather Moody", "Douglas Fowler",
"Amanda Prince", "Matthew Johnson", "Paula Kelly", "Jordan Mcintyre", "Roberta Smith", "David Silva", "Jeffery Taylor", "John Bauer", "Pedro Ferguson", "Denise West",
"Anthony Garcia", "Dean Summers", "Michael White", "Jerry Davis", "Arthur Allen", "Kelly Reeves", "Aaron Patterson", "Kerry Russell", "Kristopher Harris", "Jeremy Sanchez",
"Tracey Warner", "Rachel Hughes", "Stephanie Branch", "Megan Doyle", "Brandi Farmer", "Shaun Lewis", "Emily Smith", "Jacob Barron", "Victoria Jimenez", "Benjamin Edwards",
"Katherine Burke", "Leonard Gaines", "Tanya Graham", "Tyler Bowers", "Mathew Harris", "Helen Smith", "Sharon Coleman", "David Valdez", "Yvette Young", "Vanessa Hall",
"Daniel King", "Raymond Bradley", "Antonio Clarke", "John Price", "Olivia Ortiz", "Deborah Myers", "Linda Travis", "Kimberly Clark", "Kathleen Hawkins", "Judy Medina",
"Ryan Sampson", "Timothy Price", "Clifford Mueller", "Michael Porter", "Timothy Bennett", "Kayla Lee", "Rachel Romero", "Judy Torres", "Cindy Wilson", "Katherine Johnson",
"Breanna Oliver", "Thomas Watson", "Alexandra Bolton", "Wesley Cantu", "Curtis Scott", "Joseph West", "Eugene Huang", "Timothy Ortiz", "Gabriela Crawford", "Michelle Lawrence",
"Lisa Holmes", "Lori Mays", "Kristina Dalton", "Angelica Clements", "Karen Lopez", "Gary Moore", "Taylor Miller", "Danielle Norris", "Maurice Gonzalez", "Laura Knight",
"Jesse Johnson", "Christopher Ballard", "Sharon Larsen", "Kenneth Beard", "Christopher Sullivan", "Cathy White", "Eric Sanford", "Justin Lee", "Hannah Ayers", "Matthew Ramirez",
"Veronica Hall", "Donna Miller", "Danielle Stevens", "Peggy Mclaughlin", "Melinda Barnes", "Beth Cobb", "George Black", "Michael Rodriguez", "Bryan Garcia", "Steven Frazier",
"Sylvia Bennett", "Craig Cameron", "John Oliver", "Theodore Berry", "Darlene Gonzalez", "Curtis Jackson", "Susan Brown", "Michael Taylor", "Ryan Archer", "Margaret Moore",
"Kerri Griffith", "Richard Vaughn", "Sherry Christensen", "Kaitlyn Bennett", "Robert Jones", "Bradley Moore", "Charlotte Mathews", "Megan Lewis", "Mark Ward", "Lauren Hill",
"Lauren Allen", "Anthony Manning", "Amy Nelson", "Rachel Smith", "Alisha Leblanc", "Gary Ellis", "Amy Wood", "Kyle Evans", "Jessica Keller", "Thomas Jackson",
"Paul Conrad", "Justin Bell", "Marie Brown", "Misty Hammond", "Tom Palmer", "Adam English", "Danielle Blair", "Patricia Green", "David Griffith", "Patrick Shields",
"Melissa Hardy", "Kimberly Carter", "Jessica Carey", "Valerie Jackson", "Justin Melton", "Duane Walton", "Erica Henry", "Courtney Haley", "Kristin Santos", "Rachel Morgan",
"Heather Strickland", "John Robinson", "Kimberly Sweeney", "Courtney Harris", "Austin Dixon", "Jennifer Chapman", "John Shaw", "Joseph Mccullough", "Richard White", "Patrick Young",
"Brian Gutierrez", "Cameron Contreras", "Richard Riley", "Duane Jordan", "Barbara Jones", "Misty Garner", "Thomas Castro", "Jocelyn Chen", "Neil Baldwin", "Kayla Morgan",
"Matthew Landry", "Carrie Morrison", "John Smith", "Kathryn Fernandez", "Kevin Bentley", "Kevin Thomas", "Kathryn David", "Kristin Jackson", "Hannah Rodriguez", "Patricia Thomas",
"Jessica Cross", "Sarah Chaney", "Eric White", "Aimee Hunter", "Andrew Sutton", "Wyatt Green", "Alyssa Peters", "John Lowery", "Michele Swanson", "Edward Mckinney",
"Wendy Robertson", "Johnny Salazar", "Angela Whitaker", "Crystal Powell", "Amanda Franklin", "Kathleen Massey", "Lisa Stanley", "Ethan Adams", "Edward Petersen", "Jessica Villanueva",
"Erica Brown", "Jordan Grant", "Donna Anderson", "John Cross", "Melissa Crosby", "Sara Stanley", "Tracey Douglas", "Andrea Harper", "Elizabeth Stephens", "Penny Hunter",
"Dale Booker", "Kaitlyn Carter", "Michele Brown", "Kristin Obrien", "Robert Baker", "Brian Johnson", "Danny Henry", "Kelly Reyes", "Anthony Davis", "Jessica Ramos",
"Joseph Holder", "Charles Ward", "Diane Russell", "Cynthia Kline", "Lance Elliott", "Jared Taylor", "Joseph Henson", "Stephen Webb", "Joanne Chandler", "Lucas Lara",
"Austin Smith", "April Mitchell", "Christopher Anderson", "Brian Kelly", "Patrick Mcintyre", "Destiny Adams", "David Jones", "Daniel Eaton", "Michael Silva", "Brandon Blair",
"Edward Pierce", "Robert King", "Craig Davis", "Justin Parsons", "Michael Martinez", "Mark Caldwell", "Joseph Mcdaniel", "Amy Gardner", "Karen Brady", "Bryan Williams",
"Susan Cohen", "Megan Ramirez", "James Burton", "Anthony Stanton", "Jacob Hicks", "Joanne Miller", "Brian Davis", "Samuel Delacruz", "Sheila Martinez", "Matthew Taylor",
"Richard Gibbs", "Joanna Odonnell", "Jeremy Reese", "Natasha Joseph", "Christian Hensley", "Jose Richardson", "Matthew Tucker", "Amanda Douglas", "Mary Fleming", "Daniel Ryan",
"Steven Bruce", "Robert Warren", "Richard Valdez", "Krystal Jackson", "Renee Jones", "Stephen Sullivan", "Christina Smith", "Megan Chan", "Stephanie Hendrix", "Steven Martin",
"Jordan Young", "Dana James", "William Gomez", "Bryan Keith", "Samuel Valdez", "Douglas Cummings", "Christopher Thomas", "Danielle Garrett", "Brent Roberts", "Mark Shea",
"Anthony Buchanan", "Sonya Watts", "David Hughes", "Gina Adams", "Scott Smith", "Janet Graham", "Kendra Osborne", "Maria Norton", "Steven Jones", "Melanie Adams",
"Tanya Cooper", "Adriana Cantrell", "Richard Aguilar", "Jeffrey Johnson", "Caitlin Harper", "Robert Alexander", "Angela Wilson", "Rachel Whitehead", "Colton Reyes", "Cynthia Ward",
"Jon Guzman", "Claudia Patton", "Brad Erickson", "Carmen Herrera", "Isaac Thomas", "Eric Peterson", "Wendy Vazquez", "Daniel Burke", "Rebecca Stanley", "Veronica Gardner",
"Jennifer Parrish", "Lori Sanchez", "Jacob York", "Joseph Arias", "Joseph Simmons", "Stephanie Jackson", "Christopher Gonzalez", "Nathan Blake", "Elizabeth Reed", "Linda Ward",
"John Lawrence", "Justin Stevens", "William Adams", "Tammy Fox", "Tyler Freeman", "Jason Lambert", "Roy Howell", "Michael Bradford", "Brent Lopez", "Molly Spears",
"Amy White", "Michael Pacheco", "Tina Foster", "Lori Molina", "Tonya Wright", "Timothy Larson", "Kendra Bowers", "Joanna Petty", "Emily Anderson", "Bob Morales",
"Karl Yates", "Rachel Butler", "Christina White", "Grace Wheeler", "Colleen Gilbert", "Michelle Craig", "Patricia Roberson", "Clarence Hunt", "Autumn Keith", "Whitney Roberts",
"Ricky Butler", "Jason Simmons", "Emily Barrera", "Francisco Bradley", "Eric Holden", "Shelby Wells", "Jeanette Cain", "Michael Brown", "Deborah Reid", "Natalie Rivera",
"Kristina Duarte", "Mary Tyler", "Mark Watkins", "Keith Harper", "Brooke Martinez", "James Owens", "Whitney Young", "Casey Payne", "Francisco Gonzales", "Marissa Rivera",
"Duane Ho", "Christopher Jones", "Deanna Sanchez", "Sarah Mendoza", "James Bowen", "Debbie Campbell", "Amy Perez", "Victor Schultz", "Alyssa Chapman", "Jodi Wilson",
"Tina Nicholson", "Jon Knight", "Andrew White", "Dustin Oconnor", "Douglas Bailey", "Adrienne Trujillo", "Nicholas Andrade", "Jessica Wright", "Monica Smith", "Andrew Mcneil",
"Matthew Mitchell", "John Arnold", "Steven Davis", "Julie West", "Vernon Wilkins", "Melissa Velasquez", "Kayla Nguyen", "Michael Wyatt", "Brian King", "Richard Mcdonald",
"Howard Shannon", "Elizabeth Martin", "Tamara Watson", "Alexis Robinson", "Joann Wiley", "Mitchell Clark", "Molly Anderson", "Brandon Page", "David Martinez", "Margaret Austin",
"Michael Smith", "Elizabeth Figueroa", "Dana Hamilton", "Abigail Perry", "Jesus Johnson", "Cynthia Mcpherson", "Gabriella Ward", "Jeffrey Aguilar", "Bradley Pierce", "Maria Aguilar",
"Justin Davis", "Mary Ramirez", "Christopher Bailey", "Natasha Curry", "Kelly Hanson", "Nancy Murphy", "Crystal Herrera", "Michelle Sandoval", "Ashley Vincent", "Katherine Frazier",
"Troy Robinson", "Geoffrey Oconnor", "Michelle Giles", "Jeffery Johnson", "Victoria Ramirez", "Benjamin Callahan", "Donald Kerr", "Seth Phillips", "Miguel Mills", "David Mendez",
"Monica Bautista", "David Shea", "Danielle Hughes", "Charles Collins", "Katherine Bentley", "Destiny Wilson", "Nancy Mata", "David Watson", "Matthew Young", "Elijah Miles",
"Ronald Moore", "Theresa Hughes", "Maria Jackson", "Molly Williams", "Anthony Ramirez", "Gordon Lucero", "Misty Phillips", "Brandon Howell", "April Conley", "Gregory Washington",
"Amanda Taylor", "Elizabeth James", "Anthony Mccoy", "Christine Martinez", "Daniel Byrd", "Dawn Mckay", "David Strong", "Belinda Brooks", "Dorothy Nguyen", "Joshua Mcdaniel",
"Gregory Johnson", "Karen Vargas", "Julie Curtis", "Samantha Mason", "Tamara Sanchez", "Craig Walker", "Richard Franklin", "Kerry Allen", "Adam Daniels", "Alison Mccarty",
"Robert Wood", "Kathleen Smith", "Jeffrey Nelson", "Matthew Jones", "Thomas Garcia", "Rachel Taylor", "Gina Adkins", "Jonathan Olson", "Janet Choi", "Elizabeth Mullins",
"Brandi Hudson", "Jackie Thompson", "Suzanne Taylor", "Tammy Long", "Kyle Horn", "Jennifer Phillips", "Phillip Guzman", "Paul Stark", "Jean Roy", "Matthew Duarte",
"Kristen Hancock", "Andrew Becker", "Paige Phillips", "Michael Wolf", "Amy Tucker", "Gregory Lawrence", "Dean Small", "Mary Young", "Kelly Duke", "Ashley Green",
"Alexandra Fernandez", "Shelley Jefferson", "Lindsay Collins", "William Benson", "Sandra Dixon", "Matthew Lawson", "Linda Watson", "Destiny Phillips", "Nicholas Harris", "Dustin Walker",
"Cynthia Hammond", "Sharon Gaines", "Leah Garcia", "Taylor Kramer", "Megan Pope", "Nancy Chaney", "Joseph Williams", "Julia Nelson", "Joel Ross", "Marc Chavez",
"Cynthia Davis", "Tina Jackson", "Carol Craig", "Amanda Sullivan", "William Barrett", "Amy Roberts", "Linda Brown", "Felicia Alexander", "Bridget Parsons", "Amy Reese",
"Stephanie Wagner", "Marilyn Walker", "Diane Jones", "Ana Thompson", "Heather Foley", "Tiffany Jones", "Stacey Underwood", "Denise Hicks", "Collin Mercado", "Jose Griffin",
"Stephanie Medina", "Christopher Hernandez", "Andrea Bell", "Vanessa Owen", "Thomas Welch", "Christopher Olson", "Brian Cruz", "Samantha Hill", "Juan Avila", "Gina Hale",
"Melissa Mason", "John Ellis", "Ryan Welch", "Cory King", "Eric Reed", "Jared Johnson", "Lindsey Brown", "Rachael Gallegos", "Suzanne Harris", "Megan Beasley",
"Crystal Rivera", "David Young", "Charles Reyes", "Christopher Miller", "Dana Caldwell", "Carlos Robinson", "Brian Williams", "Tracy Owens", "Alison Turner", "Rebecca Marquez",
"Megan Willis", "Natalie Washington", "Michelle Coleman", "Kevin Carroll", "Wayne Smith", "Michele Pugh", "Regina Williams", "Kimberly Maddox", "Kyle Collins", "Alexander Smith",
"Wanda Johnson", "Steven Fisher", "Zachary Riley", "William Spears", "Anthony Wright", "Laura White", "Jeremiah Hoover", "Richard Perez", "Ryan Evans", "Rachel Carlson",
"David Clark", "Kevin Anderson", "Justin Acevedo", "Lauren Wilson", "Emily Thomas", "Renee Ramos", "Sheila Bowen", "Bryan Shaw", "Thomas Burns", "Carlos Donaldson",
"Mark Hanson", "Patricia Hall", "Karen Trujillo", "Rachel Arellano", "Lori Hill", "Jeffery Miller", "Kelly Estrada", "Juan Gray", "Kayla Delgado", "Rebecca Jones",
"Ariel Mills", "Angela Davis", "Megan Davila", "Anthony Garrison", "Kimberly Cummings", "Robert Fischer", "Kenneth Higgins", "Matthew Snyder", "Karen Jordan", "Michelle Nguyen",
"Heather Cook", "Amanda Rivera", "Veronica White", "Kevin Hicks", "Chad Johnson", "Ronald Malone", "Kristy Daniels", "John Wood", "Kevin Mullins", "Valerie Wilkins",
"Michael Atkins", "Lauren Bradley", "Dana Allen", "Austin Hall", "Nicholas Peterson", "Ethan Cole", "Timothy Carter", "Robert Carpenter", "Jessica Adams", "Erin Robinson",
"Lori Becker", "William Bates", "Gabriella Martinez", "Angelica Jones", "Charles Bennett", "Samuel Foster", "Carlos Bryant", "Thomas Parks", "Andrea Barron", "Erik Edwards",
"Jason Johnson", "Brooke Lane", "Scott Miller", "Arthur Garcia", "George White", "Christian Young", "Erica Clark", "Rebecca Romero", "Jessica Jensen", "Kevin George",
"Bonnie Cook", "Scott Bennett", "Rhonda Allison", "Jennifer Gonzalez", "Sara Watts", "Jonathan Arnold", "Jennifer Matthews", "Ann Cain", "Carmen Roth", "David Parker",
"Todd Mendez", "Reginald Higgins", "Daniel Stein", "Debra Williams", "Patrick Williams", "Sherry Martinez", "Krystal Miles", "Jennifer Sims", "Sarah Gould", "Jeffrey Douglas",
"Casey Smith", "Kayla Bailey", "Jose Anderson", "Catherine Gonzalez", "John Sosa", "Steven Young", "Erin Garcia", "Jason Huffman", "Jonathan Young", "Eric Villa",
"Mary Roberts", "Joseph Smith", "Mary Shaw", "Steven Smith", "Laura Castillo", "Sarah Welch", "Judith Santana", "Andres Monroe", "Michael Johnson", "Robert Mcdonald",
"Kristin Lynch", "Erin Jackson", "Wayne Duran", "Michelle Edwards", "Nathan Espinoza", "Daniel Sutton", "Mark Brown", "Julia Jones", "Anthony Cook", "Logan King",
"Kelly Juarez", "Martin Austin", "Linda Bell", "Nicholas Medina", "Kelsey Nelson", "Laura Watts", "Timothy Miles", "Melanie Martin", "Robert Phillips", "Jeremy Lee",
"Timothy James", "Kathy Lee", "Elizabeth Jacobs", "Michael Dougherty", "Susan Sanchez", "Jose Navarro", "Sharon Meadows", "Allen Blankenship", "Bruce Harrison", "Joshua Harris",
"Michael Wright", "Kayla Vincent", "Linda Gardner", "Tony Mcdonald", "Randy Salinas", "Michelle Johnson", "Jeffrey Perez", "Scott Ayala", "Ryan Choi", "Jeffrey Hutchinson",
"Heather Schmidt", "Alicia Blake", "Michael Jones", "Brandon Sanchez", "Lori Merritt", "Patricia Parker", "Joy Bates", "Anne Tanner", "Kimberly Hinton", "Andrew Humphrey",
"Lisa Nelson", "Kristine Rasmussen", "Philip Benson", "Paige Hall", "Tara Taylor", "Jonathan Phillips", "Lauren Caldwell", "Ashley Perez", "Amanda Lopez", "George Perry",
"Diana Franklin", "Daniel Turner", "Donna Phillips", "Linda Henderson", "Stephanie Kelly", "Alexis Smith", "Timothy Hill", "Brandi Adams", "Nicole Morrow", "Lisa Strong",
"Christopher Moody", "Daniel Howard", "Cindy Parker", "Johnny Carey", "Amanda Potter", "Charles Frazier", "Carla Thompson", "Larry Evans", "Patricia Conner", "Daniel Tucker",
"Michael Lewis", "Linda Russo", "Melissa Coffey", "Kimberly Reyes", "Christopher West", "Nicole Perez", "Amy Chang", "Paul Dickerson", "Edward Nelson", "Laura Padilla",
"Daniel Scott", "Beverly Collins", "Ashley Ali", "Wesley Griffin", "Darren Chan", "Robert Galloway", "James Johnson", "John Martin", "Kaitlin Graham", "Sergio Morris",
"Mario Barnes", "Walter Nicholson", "Mary Parker", "Charles Gentry", "Cynthia Gray", "Luke Walters", "Jacob Drake", "Michelle Collier", "Linda Sparks", "Brian Monroe",
"Vickie Williams", "Andrew Vang", "Martin Guzman", "Nicole Arroyo", "Melissa Jones", "William Buck", "David Smith", "Douglas Weaver", "Sabrina Sanford", "Margaret Spears",
"Renee Evans", "Ryan Rhodes", "Michael Hutchinson", "James Jones", "Gary Mason", "Erica Taylor", "Angela Goodwin", "Chris Ryan", "Stephanie Tran", "Cynthia Medina",
"Gregory Weber", "Ashlee Sexton", "Carolyn Gallegos", "Tiffany Williamson", "Jacob Harris", "Tiffany Gardner", "Joanne Gordon", "Douglas Lee", "Alyssa Solis", "John Sanders",
"Karina Hayes", "William Suarez", "David Miller", "Chad Lutz", "Pamela Garcia", "Julie Jordan", "Tina Simpson", "Tracy Wolf", "Alyssa Thomas", "April Franco",
"Kyle Sosa", "Katherine King", "John Lester", "Frank Cunningham", "Tracie Prince", "Eric Wheeler", "Russell Lindsey", "Joseph Wood", "Benjamin Freeman", "Autumn Carter",
"Joseph Gardner", "Kathy Gardner", "Cynthia Avila", "Jessica Berry", "Lynn Short", "Fred Stout", "Cynthia Huang", "Austin Banks", "Heidi Hines", "Tracey Perry",
"Alan Smith", "Renee Conway", "Susan Chapman", "Erin White", "Maria Maynard", "Cheryl Miller", "Ryan Davis", "Jennifer Brown", "Maria Ward", "Kristen Webster",
"William Stewart", "Sherry Mckee", "Christina Peterson", "Leah Fowler", "Jennifer Greene", "Tommy Miranda", "Brandon Adams", "Michael Pope", "Erica Miller", "Dawn Lindsey",
"Alexander Torres", "Elizabeth Alexander", "Timothy Douglas", "Karen Stevenson", "Bobby Smith", "Daniel Livingston", "Christine Cox", "Angela Gutierrez", "Karen Howard", "Jimmy Benton",
"Sarah Alexander", "Matthew Jacobs", "Jonathan Scott", "Brandi Acosta", "Brenda Gonzales", "Christopher Villanueva", "Brandon Miller", "Marissa Aguilar", "Selena Cohen", "Mark Owens",
"Lisa Kent", "Teresa Zhang", "Patricia Peck", "Brian Long", "Kevin Davis", "Joel Contreras", "Charles Delgado", "Connie Ibarra", "Kristin Orr", "Jennifer Alvarez",
"Angelica Wall", "Joann Simon", "Edward Hunt", "Mia Nielsen", "Lisa Nguyen", "Albert Anderson", "Alex Burton", "Wendy Washington", "Emily Mahoney", "Michael Bryan",
"Katelyn Duarte", "Matthew Salinas", "John Wilkerson", "Richard Cole", "Jeff Diaz", "Diana Mccoy", "Jason Bautista", "Brenda Byrd", "Johnny Santiago", "Michelle Wilson",
"Hector Beck", "Derrick Thompson", "Lori Dean", "Dana Kelly", "Cynthia Martin", "Christina Garza", "Kimberly Lambert", "Ryan Parker", "Margaret Thompson", "Michael Cook",
"Cindy Nguyen", "Ariel Allen", "Kyle Burns", "Jeffrey Lamb", "Victoria York", "Robin Lambert", "Melissa Terry", "Erica Small", "Lori White", "Victoria Casey",
"Hunter Anderson", "Christopher Edwards", "Kenneth Tate", "Monique Gomez", "Denise Shaw", "Melissa Hopkins", "Steven Thomas", "Stephen Green", "Lisa Hale", "Michael Medina",
"Amanda Griffith", "Dean Navarro", "Victoria Day", "Spencer Hopkins", "Joshua Chambers", "William Ward", "Sarah Hobbs", "Charles Sanchez", "Mark Johnson", "Nicholas Hill",
"Ashley Ryan", "Donald Potter", "Cynthia Mitchell", "Walter Smith", "Amy Crane", "Rebecca Porter", "Derek Randall", "Derek Lee", "Jack Kim", "Lynn Green",
"Angela Malone", "Matthew Edwards", "James Nichols", "Gregory Smith", "Sarah Vega", "Jacob Williams", "Linda Smith", "Diane Franklin", "Caitlin Chen", "Thomas Vaughan",
"Doris Barber", "Jody Riley", "Allen King", "Barbara Lester", "Renee Mccormick", "Julie Peterson", "Bruce Ford", "Robert Keller", "Timothy Wilson", "Julie Cummings",
"Stephanie Armstrong", "Jennifer Huerta", "Devon Larsen", "Connor Miller", "Michelle Torres", "Eric Richardson", "Brent Camacho", "Michele Benson", "Amber Zhang", "Andrew Edwards",
"Amanda Rodriguez", "Brenda Taylor", "Christopher Beck", "Luis Jackson", "Alan Lopez", "Linda Butler", "Elizabeth Bell", "Carmen English", "Alexander Mercado", "Steven Hancock",
"Brenda Kemp", "Seth Mueller", "Mark Fleming", "Mason Carlson", "Ariel Fisher", "Robert Wilson", "Samantha Moreno", "Stephanie Wright", "Martin Brown", "David Meyer",
"Ashley Evans", "David Taylor", "Megan Evans", "Timothy Williams", "Kristin Carr", "John Moore", "Brett Silva", "Shaun Williams", "Jay Myers", "Stephanie Boyd",
"Sharon Johnson", "Tiffany Fields", "Tina Phillips", "Lynn Pierce", "Natasha Williams", "John Collins", "Linda Young", "Wendy Phillips", "Ellen Ford", "Alan Bright",
"Rebecca Wong", "Heather Wall", "Christine Clark", "Melanie Leblanc", "Andrea Adams", "William Davis", "Jennifer Williams", "Stephen Ramirez", "Dawn Hurst", "Kristie Kelly",
"Molly Romero", "Robert Bailey", "Melissa Malone", "Julie Arias", "Jennifer Dalton", "William Lyons", "Rebecca Bailey", "Sarah Miranda", "Anna Lopez", "Krystal Nichols",
"Lindsay Black", "Wesley Shaw", "Daniel Hodges", "Mark Hall", "Aaron Moore", "Hector Burgess", "John Bautista", "Andrea Garrett", "Anthony King", "Hannah Williams",
"Pamela Bullock", "Kristina Garcia", "Samantha French", "Haley Abbott", "Michelle Garza", "Kaitlyn Bell", "Albert Estrada", "Jennifer Kelly", "Ana Casey", "Eileen Saunders",
"Jason Miller", "Misty Woods", "Scott Boyd", "Susan Harris", "Albert Jenkins", "Donald Preston", "Andrew Brown", "William Santos", "Emily Taylor", "Krystal Palmer",
"Robert Gallagher", "Rebecca Boyd", "Kristen Williams", "Shawn Howard", "Timothy Perkins", "Jessica Reynolds", "Sheila Lee", "Dana Stephens", "Alison Roberts", "Walter Aguilar",
"Mary Campbell", "Ashley Thompson", "Susan Frazier", "Richard Rush", "Stephanie Myers", "Elizabeth Schmidt", "Brenda Huerta", "Leslie James", "William Larsen", "Joseph Sutton",
"Stephen Cameron", "Teresa Evans", "Yvonne Duncan", "Joan Woods", "Sheila Clark", "Ann Adams", "Laurie Stafford", "Christina Medina", "Brad Griffith", "Claudia Lowe",
"Kara Rodriguez", "Willie Mckay", "Debbie Jones", "Jean Roberts", "Michael Rich", "Gregory Martin", "Lisa Quinn", "Alicia Allen", "Michael Anderson", "Heather Kennedy",
"Jason Martinez", "Lauren Ho", "Ronald Richards", "Angela Armstrong", "Jeff Hill", "Derek Norton", "Erik Stanton", "Hailey Conner", "Lisa Jordan", "Amanda Carter",
"Susan Miller", "Carl Waller", "Jeremy King", "Robin Sullivan", "Heidi Wilson", "April Wood", "Timothy Smith", "Michael Rogers", "Kimberly Cervantes", "Stephanie Carroll",
"Ann Silva", "Catherine Stewart", "Amanda Bridges", "Kim Wilson", "Brandon Johnson", "Richard Daniels", "Jane Lin", "Jimmy Wright", "William Bradford", "Alex Vargas",
"Sheila Nichols", "Stephanie Lee", "David Hamilton", "Morgan Braun", "Daniel Bowman", "Nicole Watts", "James Mitchell", "Sarah Perez", "Shelby Waller", "Mark Coleman",
"Larry Hancock", "Jon Bonilla", "Kenneth Hamilton", "Helen Gonzalez", "Gary Livingston", "Ryan Anderson", "Heather Stark", "Jon Smith", "Joseph Obrien", "Elizabeth Jimenez",
"Daniel Wallace", "Devin Webster", "Amy Moore", "Charles Paul", "Tyler Jenkins", "William Hutchinson", "James Collins", "Christian Roach", "Elizabeth Fox", "Veronica Carter",
"Michael Gonzalez", "Dustin Kane", "Stacy Anderson", "Melissa Guzman", "Andrew Jones", "Christopher Carter", "Angelica Harris", "Shannon Blankenship", "Marissa Hurst"  ];

 let nameQueue = [];
  let nameIndex = 0;

  const recentListEl = document.getElementById("recent-list");
  const totalEl = document.getElementById("total-count");
  const statusMsgEl = document.getElementById("status-msg");
  const pulse = document.getElementById("pulse");
  const widget = document.getElementById("social-proof-widget");

  let state = {
    date: currentDateString(),
    total: STARTING_TOTAL,
    recent: [],
    nameIndex: 0
  };

  function currentDateString() {
    return new Date().toISOString().slice(0, 10);
  }

  function getNextName() {
    if (nameIndex >= fullNameList.length) return null;
    const name = fullNameList[nameIndex];
    nameIndex++;
    state.nameIndex = nameIndex;
    return name;
  }

  function saveState() {
    try {
      localStorage.setItem(STORAGE_KEY, JSON.stringify({ ...state, nameIndex }));
    } catch {}
  }

  function loadState() {
    try {
      const raw = localStorage.getItem(STORAGE_KEY);
      if (!raw) return resetState();
      const parsed = JSON.parse(raw);
      if (parsed.date !== currentDateString()) return resetState();
      state = {
        date: parsed.date,
        total: typeof parsed.total === "number" ? parsed.total : STARTING_TOTAL,
        recent: Array.isArray(parsed.recent) ? parsed.recent.slice(0, MAX_RECENT) : [],
        nameIndex: typeof parsed.nameIndex === "number" ? parsed.nameIndex : 0
      };
      nameIndex = state.nameIndex;
    } catch {
      resetState();
    }
  }

  function resetState() {
    nameIndex = 0;
    const now = Date.now();
    const seed = [];
    for (let i = 0; i < STARTING_TOTAL; i++) {
      const name = getNextName();
      if (!name) break;
      seed.push({
        name: name,
        timestamp: now - Math.floor(Math.random() * 180000)
      });
    }
    state = {
      date: currentDateString(),
      total: seed.length,
      recent: seed
    };
    saveState();
  }

  function addPurchase() {
    const name = getNextName();
    if (!name) return;
    const entry = {
      name: name,
      timestamp: Date.now()
    };
    state.recent.unshift(entry);
    if (state.recent.length > MAX_RECENT) state.recent.pop();
    state.total++;
    saveState();
    refreshUI();
    triggerPulse();
    flash(`${entry.name} just bought "${PRODUCT_NAME}"`);
  }

  function flash(text) {
    statusMsgEl.innerHTML = `<span style="color:#00ffff; font-weight:600;">${text}</span>`;
    clearTimeout(window.flashTimeout);
    window.flashTimeout = setTimeout(() => {
      statusMsgEl.innerHTML = `<span style="color:#00ffff;">Tracking today's activity.</span>`;
    }, 3500);
  }

  function refreshUI() {
    recentListEl.innerHTML = "";
    state.recent.forEach(e => {
      const row = document.createElement("div");
      row.style.display = "flex";
      row.style.flexDirection = "column";
      row.style.background = "rgba(255,255,255,0.05)";
      row.style.padding = "8px 12px";
      row.style.borderRadius = "8px";
      row.style.fontSize = "0.78rem";
      row.style.height = "60px";
      row.style.boxSizing = "border-box";
      row.innerHTML = `
        <div style="font-weight:600; color:#00ffff;">${e.name} just bought "${PRODUCT_NAME}"</div>
        <div style="font-size:.55rem; opacity:.8;">just now</div>
      `;
      recentListEl.appendChild(row);
    });
    totalEl.textContent = state.total;
  }

  function triggerPulse() {
    pulse.innerHTML = "";
    const ring = document.createElement("div");
    ring.style.position = "absolute";
    ring.style.top = "50%";
    ring.style.left = "50%";
    ring.style.width = "120%";
    ring.style.height = "120%";
    ring.style.borderRadius = "50%";
    ring.style.border = "3px solid rgba(0,255,255,0.3)";
    ring.style.transform = "translate(-50%,-50%) scale(0.8)";
    ring.style.opacity = "0";
    ring.style.transition = "transform .6s ease-out, opacity .6s ease-out";
    pulse.appendChild(ring);
    requestAnimationFrame(() => {
      ring.style.opacity = "1";
      ring.style.transform = "translate(-50%,-50%) scale(1.2)";
    });
    setTimeout(() => {
      ring.style.opacity = "0";
      setTimeout(() => pulse.innerHTML = "", 400);
    }, 500);
  }

  function scheduleNext() {
    const delay = Math.floor(Math.random() * (MAX_INTERVAL_MS - MIN_INTERVAL_MS + 1)) + MIN_INTERVAL_MS;
    setTimeout(() => {
      addPurchase();
      scheduleNext();
    }, delay);
  }

  let lastScrollY = window.scrollY;
  let targetOffset = 0;
  let displayedOffset = 0;

  window.addEventListener("scroll", () => {
    const currentY = window.scrollY;
    const delta = currentY - lastScrollY;
    targetOffset = Math.max(-15, Math.min(15, delta * 0.3));
    lastScrollY = currentY;
  });

  function animateFloat() {
    displayedOffset += (targetOffset - displayedOffset) * 0.1;
    targetOffset *= 0.92;
    widget.style.transform = `translateY(${displayedOffset}px)`;
    requestAnimationFrame(animateFloat);
  }

  loadState();
  refreshUI();
  scheduleNext();
  requestAnimationFrame(animateFloat);
})();